cd "Z:\work\Baze\SILC_Serbia\2019"

*set path on your computer
*note: import spss is a stata 16/17 function
*for the versions before that use other 
*import options in stata
import spss using "p-file.sav", clear
rename *, low
order phid, first
rename pb030 idperson
rename phid idhh
save p-file, replace

* definition of person with disaiblity based 
* on harmonized data
gen disabled = pl086>=6
keep idperson disabled
save disabled, replace

import spss using "d-file.sav", clear
rename *, low
rename db030 idhh
rename db090 dweight
save d-file, replace

keep idhh dweight
save weight, replace

import spss using "h-file.sav", clear
rename *, low
rename hb030 idhh
save h-file, replace

cd "Z:\work\Baze\SILC_Serbia\2019"
import spss using "r-file.sav", clear
drop if RB110 == 5 | RB110 == 6
rename *, low

order rhid, first
rename rb030 idperson
rename rb240 idpartner
rename rhid idhh
rename rb040 idhh_c
rename rb050 weight
rename rb070 month
rename rb080 year
gen female = rb090
recode female (1=0) (2=1)
gen in_school12 = rl020!=.

* merge disabled 
merge 1:1 idperson using disabled
drop _merge

* generate age variable
gen age = rb010 - year - 1
recode age (-1=0)
sum age
* source https://ec.europa.eu/eurostat/statistics-explained/index.php?title=EU_statistics_on_income_and_living_conditions_(EU-SILC)_methodology_%E2%80%93_concepts_and_contents

* identify mothers of small children
preserve 
rename rb230 idmother
rename rb220 idfather
bys idhh: gen j = _n

keep idhh idperson j age idmother idpartner idfather disabled
reshape wide idperson age idmother idfather idpartner ///
			 disabled , i(idhh) j(j) 
forvalues i = 1(1)22 {
gen ismother01`i' = 0
gen ismother017`i' = 0
gen isfather017`i' = 0
gen haspartner`i' = 0
gen haspartnerdi`i' = 0
forvalues j = 1(1)22 {
replace ismother01`i' = 1 if idperson`i'== idmother`j' ///
							 & (age`j'==0 | age`j'==1)
replace ismother017`i' = 1 if idperson`i'== idmother`j' ///
							 & (age`j'<=17)
replace isfather017`i' = 1 if idperson`i'== idfather`j' ///
							 & (age`j'<=17)
replace haspartner`i' = 1 if idperson`i'== idpartner`j' 
replace haspartnerdi`i' = 1 if idperson`i'== idpartner`j' & 							disabled`j'==1
}
}

reshape long idperson age idmother ismother01 ismother017 isfather017 haspartner haspartnerdi, i(idhh) j(j) 
drop if idperson==""
keep idperson ismother01 ismother017 isfather017 haspartner haspartnerdi
save ismother01, replace
restore
* merge variables
merge 1:1 idperson using ismother01

keep idhh idperson month year female idhh_c weight age ismother01 ismother017 isfather017 haspartner haspartnerdi disabled in_school12
save r-file, replace


